import java.sql.*;
import java.io.*;

public class DBConsole
{
  protected Connection conn;
  protected BufferedReader brInput;
  public DBConsole(String connStr, String user, String pass)
  throws Exception
  {
    conn = DBConnection.getConnection(connStr, user, pass);
    if(conn == null){
      throw new Exception(
        "Nie mona nawiza poczenia z baz.");
    }
    try{
      brInput = new BufferedReader(
        new InputStreamReader(System.in));
    }
    catch(Exception e){
      throw new Exception(
        "Bd przy tworzeniu strumienia wejciowego.");
    }
  }
  public static void main(String args[])
  throws Exception
  {
    DBConsole dbcon = new DBConsole(
      "jdbc:mysql://localhost:3306/test", "test", "test");
    dbcon.start();
  }
  public void start()
  {
    String line;
    while(true){
      try{
        System.out.print(">");
        line = brInput.readLine();
        if (line.equals("quit")){
          conn.close();
          break;
        }
        else{
          doQuery(line);
        }
      }
      catch(IOException e){
        log("Bd wejcia-wyjcia: " + e);
        System.exit(-1);
      }
      catch(Exception e){
        log("Bd oglny: " + e);
        System.exit(-1);
      }
    }
  }
  public void doQuery(String query)
  {
    try{
      Statement stm = conn.createStatement();
      if(stm.execute(query)){
        //zapytanie zwracajace zbir rekordw
        ResultSet rs = stm.getResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colsNo = rsmd.getColumnCount();
        
        //pobranie i wywietlenie nazw kolumn
        String str = "";
        for(int i = 1; i <= colsNo; i++){
          str += rsmd.getColumnName(i);
          str += i < colsNo ? " | " : "";
        }
        System.out.println(str);
        
        //pobranie i wywietlenie wynikw zapytania
        str = "";
        while(rs.next()){
          for(int i = 1; i <= colsNo; i++){
            str += rs.getString(i);
            str += i < colsNo ? " | " : "";
          }
          str += "\n";
        }
        System.out.print(str);
        rs.close();
      }
      else{
        //zapytanie zwracajce liczb zmodfikowanych wierszy
        System.out.println("Liczba zmodyfikowanych rekordw: " + 
           stm.getUpdateCount());
      }
    }
    catch(SQLException e){
      System.out.println("Bd przy przetwarzaniu danych: " + e);
    }
  }
  public void log(String msg)
  {
    //System.out.println(msg);
  }
}
